<?php
require_once __DIR__ . '/../config/database.php';

try {
    // Create supplier_messages table
    $sql = "CREATE TABLE IF NOT EXISTS supplier_messages (
        id INT AUTO_INCREMENT PRIMARY KEY,
        supplier_id INT NOT NULL,
        message TEXT NOT NULL,
        amount DECIMAL(10,2) NOT NULL,
        type ENUM('sms', 'whatsapp', 'email') NOT NULL,
        status ENUM('sent', 'failed') DEFAULT 'sent',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (supplier_id) REFERENCES suppliers(id) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

    $pdo->exec($sql);
    echo "Supplier messages table created successfully\n";

    // Add index for better performance
    $index_sql = "CREATE INDEX idx_supplier_messages_supplier_id ON supplier_messages(supplier_id)";
    $pdo->exec($index_sql);
    echo "Index created successfully\n";

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}

?> 